<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $model bitcream\ndt\custom\common\models\BandOfDecoration */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="band-of-decoration-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'collection_id')->hiddenInput(['value'=> $collection])->label(false); ?>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'decoration_id')->widget(Select2::classname(), [
                'name' => 'decoration_id',
                'class' => 'form-group decoration_ids form-control',
                'value' => ArrayHelper::map($decorations, 'id', function ($decoration) {
                    return $decoration['title'];
                }),
                'id' => 'product_id',
                'data' => ArrayHelper::map($decorations, 'id', function ($decoration) {
                    return $decoration['title'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select decoration')]
            ])->label(Yii::t('app', 'Decoration'));?>
        </div>
    </div>

    <div class='row'>
        <div class='col-md-6 col-xs-12'>
            <?= $form->field($model, 'title')->textInput(['maxlength' => true]) ?>

        </div>
    </div>

    <div class='row'>
        <div class='col-md-6 col-xs-12'>
            <?= $form->field($model, 'introduction_text')->textarea(['rows' => 6]) ?>

        </div>
    </div>

    <div class='row'>
        <div class='col-md-6 col-xs-12'>
            <label class="control-label"><?=Yii::t('app','Layout')?></label>
            <?= Select2::widget([
                'name' => 'BandOfDecoration[layout]',
                'data' => [
                    '1' => "Layout 1", 
                    '2' => "Layout 2", 
                    '3' => "Layout 3"
                ],
                'value' => $model->layout,
                'options' => [
                    'placeholder' => Yii::t('app','Select a layout ...'),
                ],
            ]);?><br>
        </div>
    </div>

    <div class='row'>
        <div class='col-md-6 col-xs-12'>
            <?=$form->field($model, 'layout_img_1')->widget(floor12\files\components\FileInputWidget::class) ?>
        </div>
    </div>

    <div class='row'>
        <div class='col-md-6 col-xs-12'>
            <?=$form->field($model, 'layout_img_2')->widget(floor12\files\components\FileInputWidget::class) ?>
        </div>
    </div>

    <div class='row'>
        <div class='col-md-6 col-xs-12'>
            <?=$form->field($model, 'layout_img_3')->widget(floor12\files\components\FileInputWidget::class) ?>
        </div>
    </div>
<!-- 
    <div class='row'>
        <div class='col-md-6 col-xs-12'>
            <?= $form->field($model, 'intended_use')->textInput(['maxlength' => true]) ?>

        </div>
    </div> -->

    <div class="form-group">
        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
