<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use Emberware\Evidia\Toolkit\Field\WYSIWYG;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $model bitcream\ndt\custom\common\models\Collection */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="collection-form">

    <?php $form = ActiveForm::begin(); ?>
    <div class='row'>
        <div class='col-md-6 col-xs-12'>
            <?= $form->field($model, 'title')->textInput(['maxlength' => true]) ?>

        </div>
    </div>

    <div class='row'>
        <div class='col-md-6 col-xs-12'>
            <?= $form->field($model, 'description')->widget(WYSIWYG::className()) ?>

        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'customer_user_id')->widget(Select2::classname(), [
                'name' => 'customer_user_id',
                'class' => 'form-group customer_user_ids form-control',
                'value' => ArrayHelper::map($customerUsers, 'id', function ($customerUser) {
                    return $customerUser['name']." ".$customerUser['surname'];
                }),
                'id' => 'collection_id',
                'data' => ArrayHelper::map($customerUsers, 'id', function ($customerUser) {
                    return $customerUser['name']." ".$customerUser['surname'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select customer user')]
            ])->label(Yii::t('app', 'Customer user'));?>
        </div>
    </div>

    <div class="form-group">
        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
