<?php

namespace bitcream\ndt\custom\common\models;

use Yii;
use yii\helpers\ArrayHelper;
use Emberware\Evidia\Toolkit\Model\SoftDeleteBehavior;
use bitcream\ndt\custom\common\behaviors\StatusBehaviors;
use bitcream\ndt\custom\common\behaviors\CreateUpdateBehaviors;
use bitcream\pim\custom\common\models\Product; 

/**
 * This is the model common class for table "band_of_decoration".
 */
class BandOfDecoration extends base\BandOfDecoration
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
            'files' => [
                'class' => 'floor12\files\components\FileBehaviour',
                'attributes' => [
                    'layout_img_1',
                    'layout_img_2',
                    'layout_img_3',
                ],
            ],
       ]);
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return ArrayHelper::merge(parent::rules(), [
            ['layout_img_1', 'file', 'extensions' => ['jpg', 'png', 'jpeg', 'gif'], 'maxFiles' => 1],
            ['layout_img_2', 'file', 'extensions' => ['jpg', 'png', 'jpeg', 'gif'], 'maxFiles' => 1],
            ['layout_img_3', 'file', 'extensions' => ['jpg', 'png', 'jpeg', 'gif'], 'maxFiles' => 1],
        ]);
    }

     /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return ArrayHelper::merge(parent::attributeLabels(), [
            'layout_img_1' => Yii::t('app', 'Layout image 1'),
            'layout_img_2' => Yii::t('app', 'Layout image 2'),
            'layout_img_3' => Yii::t('app', 'Layout image 3'),
        ]);
    }

    public static function find(){
        return parent::find()->where([
            'status' => 30, //prodotti non cancellati
        ]);
    }

    /**
     * Gets query for [[Decoration]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getDecoration()
    {
        return $this->hasOne(Decoration::className(), ['id' => 'decoration_id'])->andWhere(['status' => '30']);
    }

    /**
     * Gets query for [[BandOfDecorationColors]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getBandOfDecorationColors()
    {
        return $this->hasMany(BandOfDecorationColor::className(), ['band_of_decoration_id' => 'id'])->andWhere(['status' => '30']);
    }

    public function fields(){
        return [
            'id',
            'collectionId' => 'collection_id',
            'title',
            'introductionText' => 'introduction_text',
            'decoration' => 'decoration', 
        ];
    }

    public function getDecorationColors(){
        if(!empty($this->bandOfDecorationColors)){
            return $this->bandOfDecorationColors;
        }else{
            return $this->decoration->decorationColors;
        }
    }

}
