<?php

namespace bitcream\ndt\custom\common\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use bitcream\ndt\custom\common\models\BandOfDecorationColor;

/**
 * BandOfDecorationColorSearch represents the model behind the search form of `bitcream\ndt\custom\common\models\BandOfDecorationColor`.
 */
class BandOfDecorationColorSearch extends BandOfDecorationColor
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'band_of_decoration_id', 'decoration_color_id'], 'integer'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = BandOfDecorationColor::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere(
            ['=', 'status', 30]
        );

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'band_of_decoration_id' => $this->band_of_decoration_id,
            'decoration_color_id' => $this->decoration_color_id,
        ]);

        return $dataProvider;
    }
}
