<?php

namespace bitcream\ndt\custom\common\models;

use Yii;
use yii\helpers\ArrayHelper;
use Emberware\Evidia\Toolkit\Model\SoftDeleteBehavior;
use bitcream\ndt\custom\common\behaviors\StatusBehaviors;
use bitcream\ndt\custom\common\behaviors\CreateUpdateBehaviors;
use yii\helpers\Inflector;

/**
 * This is the model common class for table "collection".
 */
class Collection extends base\Collection
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
            'slug' => [
                'class' => 'skeeks\yii2\slug\SlugBehavior',
                'slugAttribute' => 'slug',                      //The attribute to be generated
                'attribute' => 'title',       
                'slugifyOptions' => [
                    //'lowercase' => true,
                    'separator' => '-',
                    //'trim' => true
                    //'regexp' => '/([^A-Za-z0-9]|-)+/',
                    //'rulesets' => ['russian'],
                    //@see all options https://github.com/cocur/slugify
                ]
            ],
       ]);
    }

    public static function find(){
        return parent::find()->where([
            'status' => 30, //prodotti non cancellati
        ]);
    }
    
    /**
     * Gets query for [[BandOfDecorations]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getBandOfDecorations()
    {
        return $this->hasMany(BandOfDecoration::className(), ['collection_id' => 'id'])->andWhere(['status' => '30']);
    }


    public function fields(){
        return [
            'id',
            'title',
            'slug',
            'description',            
            'creation_date' => 'created_at',            
            'decorsRow' => 'bandOfDecorations',
            //'downloads',
        ];
    }

    public function getSlug(){
        return Inflector::slug($this->title, '-');
    }
    
}
