<?php

namespace bitcream\ndt\custom\common\models;

use Yii;
use yii\helpers\ArrayHelper;
use bitcream\pim\custom\common\models\ProductModel;
use bitcream\pim\custom\common\models\Product;
use yii\helpers\Inflector;
use bitcream\ndt\custom\common\models\Favourites;

/**
 * This is the model common class for table "decoration_color".
 */
class DecorationColor extends \bitcream\pim\custom\common\models\Product
{
    public static $modelParent = "decoration";
    public static $modelSlug = "decoration_color";

    public function fields(){
        return [
            'id',
            'favoriteId' => 'favorites',
            'title',
            'images' => function(){
                return [
                    'thumbnail' => $this->thumbnail,
                    'expanded' => $this->expanded,
                ];
            },
            'renders' => function(){
                return [
                    $this->renders,
                ];
            },
        ];
    }

    public function getSlug(){
        return Inflector::slug($this->title, '-');
    }
    
    public function getCode(){        
        return $this->getDynamicAttributeValue("code");        
    }

    public function setCode($value){        
        return $this->setDynamicAttribute("code", $value);        
    }

    public function getFavorites(){
        $favorite = Favourites::find()->where(['decoration_color_id' => $this->id, 'customer_user_id' => Yii::$app->user->id, 'status' => 30])->one();
        if(!empty($favorite)) return $favorite->id;
        return "";
    }

    public function getThumbnail(){
        if(isset($this->preview_image)){
            $href = str_replace('api', 'backend', Yii::$app->params['serverName'].$this->preview_image->href);
            return [
                'href' => $href,
                'type' => $this->preview_image->content_type,
                'size' => $this->preview_image->size,                   
            ];
        }
        return "";
    }

    public function getExpanded(){
        if(isset($this->development_image)){
            $href = str_replace('api', 'backend', Yii::$app->params['serverName'].$this->development_image->href);
            return [
                'href' => $href,
                'type' => $this->development_image->content_type,
                'size' => $this->development_image->size,                   
            ];
        }
        return "";
    }

    public function getRenders(){
        if(isset($this->decor_in_use)){
            $href = str_replace('api', 'backend', Yii::$app->params['serverName'].$this->decor_in_use->href);
            return [
                'href' => $href,
                'type' => $this->decor_in_use->content_type,
                'size' => $this->decor_in_use->size,                   
            ];
        }
        return "";
    }
    
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return ArrayHelper::merge(parent::rules(), [

        ]);
    }

     /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return ArrayHelper::merge(parent::attributeLabels(), [

        ]);
    }

    public function getPreview_image(){        
        return $this->getDynamicAttributeValue("preview_image");        
    }

    public function setPreview_image($value){        
        return $this->setDynamicAttribute("preview_image", $value);        
    }

    public function getDevelopment_image(){        
        return $this->getDynamicAttributeValue("development_image");        
    }

    public function setDevelopment_image($value){        
        return $this->setDynamicAttribute("development_image", $value);        
    }

    public function getDecor_in_use(){        
        return $this->getDynamicAttributeValue("decor_in_use");        
    }

    public function setDecor_in_use($value){        
        return $this->setDynamicAttribute("decor_in_use", $value);        
    }
    
}
