<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use Emberware\Evidia\Toolkit\Field\WYSIWYG;
use bitcream\pim\custom\common\widget\AttributeDynamicWidget;

/* @var $this yii\web\View */
/* @var $model bitcream\ndt\custom\common\models\Category */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="category-form">

    <?php $form = ActiveForm::begin(); ?>
        <div class='row'>
            <div class='col-md-6 col-xs-12'>
                <?= $form->field($model, 'title')->textInput(['maxlength' => true]) ?>

            </div>
        </div>

        <div class='row'>
            <div class='col-md-6 col-xs-12'>
                <?= $form->field($model, 'short_title')->textInput(['maxlength' => true]) ?>

            </div>
        </div>

        <div class='row'>
            <div class='col-md-6 col-xs-12'>
                <?= $form->field($model, 'description')->widget(WYSIWYG::className()) ?>

            </div>
        </div>

        <?= AttributeDynamicWidget::widget(['model' => $model, 'form' => $form]);?>

    <div class="form-group">
        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
