<?php

namespace bitcream\ndt\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%favourites}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%user}}`
 */
class M220204153127AddCustomerUserIdColumnToFavouritesTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%favourites}}', 'customer_user_id', $this->integer()->null());

        // creates index for column `customer_user_id`
        $this->createIndex(
            '{{%idx-favourites-customer_user_id}}',
            '{{%favourites}}',
            'customer_user_id'
        );

        // add foreign key for table `{{%user}}`
        $this->addForeignKey(
            '{{%fk-favourites-customer_user_id}}',
            '{{%favourites}}',
            'customer_user_id',
            '{{%user}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%user}}`
        $this->dropForeignKey(
            '{{%fk-favourites-customer_user_id}}',
            '{{%favourites}}'
        );

        // drops index for column `customer_user_id`
        $this->dropIndex(
            '{{%idx-favourites-customer_user_id}}',
            '{{%favourites}}'
        );

        $this->dropColumn('{{%favourites}}', 'customer_user_id');
    }
}
