<?php

use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;

?>
<div class="band-of-decoration-color-datatable">
    <?=        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'band-of-decoration-color-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                ['attribute'=>Yii::t('app', 'id'),
                    'format'=>'raw',
                    'value' => function ($model, $key, $index, $column) use ($bandOfDecoration)
                    {return Html::a($model->id, ['band-of-decoration-color/update','id'=>$model->id, 'bandOfDecoration' => $bandOfDecoration ]);}
                ],
                ['attribute'=>Yii::t('app', 'Band of decoration'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return $data->bandOfDecoration->title;}
                ],
                ['attribute'=>Yii::t('app', 'Decoration Color'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return $data->decorationColor->title;}
                ],
                [
                    'format'=>'raw',
                    'label' => Yii::t('app', 'Actions'),
                    'value' => function ($model, $key, $index, $column) use ($bandOfDecoration)
                    {
                        return Html::a('<i class="fa fa-trash"></i>', ['band-of-decoration-color/delete','id'=>$model->id, 'bandOfDecoration' => $bandOfDecoration],[
                            'data' => [
                                'confirm' => Yii::t('app', 'Are you sure you want to delete this band of decoration color?'),
                                'method' => 'post',
                            ]
                        ]);
                    }
                ],
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('app',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
     ?>

</div>