<?php

namespace bitcream\ndt\custom\common\models;

use Yii;
use yii\helpers\ArrayHelper;
use bitcream\pim\custom\common\models\Product;
use bitcream\pim\custom\common\models\Attribute;
use bitcream\pim\custom\common\models\ProductValue;
use yii\helpers\Inflector;

/**
 * This is the extended model class for table "{{%product}}".
 */
class Category extends \bitcream\pim\custom\common\models\Product
{    
    public static $modelSlug = "category";

    public function fields(){
        return [
            'id',
            'title',
            'slug' => 'slug',
            'description', 
        ];
    }

    /**
     * Gets query for [[Decoration]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getDecorations()
    {
        return $this->hasMany(Decoration::className(), ['product_parent_id' => 'id'])->andWhere(['status' => '30']);
    }


    public function getSlug(){
        return Inflector::slug($this->title, '-');
    }

    public function getPhoto(){        
        return $this->getDynamicAttributeValue("photo");        
    }

    public function setPhoto($value){        
        return $this->setDynamicAttribute("photo", $value);        
    }

    public function getCover_image(){        
        return $this->getDynamicAttributeValue("cover_image");        
    }

    public function setCover_image($value){        
        return $this->setDynamicAttribute("cover_image", $value);        
    }

    public function getDrawing(){        
        return $this->getDynamicAttributeValue("drawing");        
    }

    public function setDrawing($value){        
        return $this->setDynamicAttribute("drawing", $value);        
    }

    public function getData_sheet(){        
        return $this->getDynamicAttributeValue("data_sheet");        
    }

    public function setData_sheet($value){        
        return $this->setDynamicAttribute("data_sheet", $value);        
    }

}