<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model bitcream\ndt\custom\common\models\Collection */

$this->title = $model->title;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Collections'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="collection-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a(Yii::t('app', 'Update'), ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a(Yii::t('app', 'Delete'), ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'id',
            'title',
            'description:ntext',
            'cover:ntext',
        ],
    ]) ?>

    <hr>

    <h1><?= Html::encode(Yii::t('app', 'Band Of Decoration')) ?></h1>

    <p>
        <?= Html::a(Yii::t('app', 'Create Band Of Decoration'), ['band-of-decoration/create', 'collection' => $model->id], ['class' => 'btn btn-success']) ?>
    </p>

    <?=  $this->render('../band-of-decoration/_datatable',[
            'searchModel' => $bandOfDecorationsearchModel,
            'dataProvider' => $dataProviderBandOfDecoration,
            'collection' => $model->id,
    ]) ?>

</div>
