<?php

namespace bitcream\ndt\custom\common\models\base;

use Yii;
use emberware\evidia\users\common\models\User;
/**
 * This is the model class for table "collection".
 *
 * @property int $id
 * @property string|null $title
 * @property string|null $slug
 * @property string|null $description
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 * @property int|null $customer_user_id
 *
 * @property BandOfDecoration[] $bandOfDecorations
 * @property User $customerUser
 * @property Favourites[] $favourites
 */
class Collection extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'collection';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['description'], 'string'],
            [['status', 'created_user_id', 'updated_user_id', 'customer_user_id'], 'integer'],
            [['title', 'slug', 'created_at', 'updated_at'], 'string', 'max' => 255],
            [['customer_user_id'], 'exist', 'skipOnError' => true, 'targetClass' => User::className(), 'targetAttribute' => ['customer_user_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'title' => Yii::t('app', 'Title'),
            'slug' => Yii::t('app', 'Slug'),
            'description' => Yii::t('app', 'Description'),
            'status' => Yii::t('app', 'Status'),
            'created_at' => Yii::t('app', 'Created At'),
            'created_user_id' => Yii::t('app', 'Created User ID'),
            'updated_at' => Yii::t('app', 'Updated At'),
            'updated_user_id' => Yii::t('app', 'Updated User ID'),
            'customer_user_id' => Yii::t('app', 'Customer User ID'),
        ];
    }

    /**
     * Gets query for [[BandOfDecorations]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getBandOfDecorations()
    {
        return $this->hasMany(BandOfDecoration::className(), ['collection_id' => 'id']);
    }

    /**
     * Gets query for [[CustomerUser]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCustomerUser()
    {
        return $this->hasOne(User::className(), ['id' => 'customer_user_id']);
    }

    /**
     * Gets query for [[Favourites]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getFavourites()
    {
        return $this->hasMany(Favourites::className(), ['collection_id' => 'id']);
    }
}
