<?php

namespace bitcream\ndt\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%band_of_decoration_color}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%band_of_decoration}}`
 */
class M220210145317AddBandOfDecorationIdColumnToBandOfDecorationColorTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%band_of_decoration_color}}', 'band_of_decoration_id', $this->integer()->null());

        // creates index for column `band_of_decoration_id`
        $this->createIndex(
            '{{%idx-band_of_decoration_color-band_of_decoration_id}}',
            '{{%band_of_decoration_color}}',
            'band_of_decoration_id'
        );

        // add foreign key for table `{{%band_of_decoration}}`
        $this->addForeignKey(
            '{{%fk-band_of_decoration_color-band_of_decoration_id}}',
            '{{%band_of_decoration_color}}',
            'band_of_decoration_id',
            '{{%band_of_decoration}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%band_of_decoration}}`
        $this->dropForeignKey(
            '{{%fk-band_of_decoration_color-band_of_decoration_id}}',
            '{{%band_of_decoration_color}}'
        );

        // drops index for column `band_of_decoration_id`
        $this->dropIndex(
            '{{%idx-band_of_decoration_color-band_of_decoration_id}}',
            '{{%band_of_decoration_color}}'
        );

        $this->dropColumn('{{%band_of_decoration_color}}', 'band_of_decoration_id');
    }
}
