<?php

namespace bitcream\ndt\custom\console\controllers;

use Yii;
use yii\console\Controller;
use yii\console\ExitCode;

/**
 * Manage users module permissions
 */
class RbacController extends Controller
{
    public $defaultAction ="init";

   /**
     * Init users permissions and assign the permissions to role
     */

    public function actionInit()
    {

        $auth = Yii::$app->authManager;

        $viewSysadminMenu = $auth->getPermission('viewSysadminMenu');
        if( empty($viewSysadminMenu)){
            $viewSysadminMenu = $auth->createPermission('viewSysadminMenu');
            $viewSysadminMenu->description = 'permesso per menu di sistema';
            $auth->add($viewSysadminMenu);
        }

        $viewApplicationItems = $auth->getPermission('viewApplicationItems');
        if( empty($viewApplicationItems)){
            $viewApplicationItems = $auth->createPermission('viewApplicationItems');
            $viewApplicationItems->description = 'permesso per menu admin';
            $auth->add($viewApplicationItems);
        }

        $adminRole = $auth->getRole('admin');
        if($adminRole){
            if(!$auth->hasChild($adminRole, $viewApplicationItems)){
                $auth->addChild($adminRole, $viewApplicationItems);
            }
            if(!$auth->hasChild($adminRole, $viewSysadminMenu)){
                $auth->addChild($adminRole, $viewSysadminMenu);
            }
        };

        return ExitCode::OK;
    }
}