<?php

namespace bitcream\ndt\custom\common\models;

use Yii;
use emberware\evidia\useroptions\common\models\UserOption;
use emberware\evidia\users\common\models\User;
/**
 * This is the model class for table "{{%user}}".
 * @property String $customerCod
 * @property String $agent
 */
class CustomerUser extends base\CustomerUser
{    
    public function fields(){
        return [
            'id',
            'username',
            'name',
            'surname',
            'phone',
            'customerCod' => 'customerCod',
            'agent' => 'agent',
            'email',
        ];
    }

    public static function getCurrentUser(){
        return CustomerUser::findOne(Yii::$app->user->id);
    }

    public function getCustomerCod(){
        return UserOption::getUserOption("customer_cod", $this);
    }

    public function setCustomerCod(String $customerCod, $user){
        $this->unsetCustomerCod($user); 
        UserOption::setUserOptionNewUser("customer_cod", $customerCod, $user);
        return true;
    }

    public function unsetCustomerCod($user)
    {
        $customerCod = UserOption::find()->where(['user_id' => $user->id, 'field' => 'customer_cod'])->one();
        if($customerCod){
            $customerCod->delete();
        }        
        return true;
    }
    
    public function getAgent(){
        return UserOption::getUserOption("agent", $this);
    }

    public function setAgent(String $agent, $user){
        $this->unsetAgent($user); 
        UserOption::setUserOptionNewUser("agent", $agent, $user);
        return true;
    }

    public function unsetAgent($user)
    {
        $agent = UserOption::find()->where(['user_id' => $user->id, 'field' => 'agent'])->one();
        if($agent){
            $agent->delete();
        }        
        return true;
    }

    public function createUser($userData){
        $model = new CustomerUser();
        $model->username = $userData['username'];
        $model->name = $userData['name'];
        $model->surname = $userData['surname'];
        $model->email = $userData['email'];
        $model->password_hash = Yii::$app->security->generatePasswordHash($userData['password_hash']);
        $model->auth_key = $model->generateAuthKey();
        $model->created_user_id = (string)Yii::$app->user->id;
        $model->updated_user_id = (string)Yii::$app->user->id;
        $model->created_at = (string)time();
        $model->updated_at = (string)time();
        $model->status = 30;
        $model->date_subscription = (string)time();
        $model->save();

        $model->setCustomerCod($userData['customerCod'], $model);
        $model->setAgent($userData['agent'], $model);

        $auth = \Yii::$app->authManager;
        $customerRole = $auth->getRole('customer');
        $auth->assign($customerRole, $model->id);

        return $model;
    }

    public static function getAllCustomerUsers(){

        return CustomerUser::find()
            ->join('LEFT JOIN','auth_assignment','auth_assignment.user_id = id')
            ->where(['auth_assignment.item_name' => 'customer'])
            ->all();

    }
}