<?php

namespace bitcream\ndt\custom\backend\controllers;

use Yii;
use bitcream\ndt\custom\common\models\DecorationColor;
use bitcream\ndt\custom\common\models\Decoration;
use bitcream\ndt\custom\common\models\BandOfDecoration;
use bitcream\ndt\custom\common\models\DecorationColorSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * DecorationColorController implements the CRUD actions for DecorationColor model.
 */
class DecorationColorController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all DecorationColor models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new DecorationColorSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single DecorationColor model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new DecorationColor model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new DecorationColor();        

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            $model->saveDynamicAttributes(Yii::$app->request->post()['DecorationColor']);
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
            'decorations' => $model->productParents
        ]);
    }

    /**
     * Updates an existing DecorationColor model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            $model->saveDynamicAttributes(Yii::$app->request->post()['DecorationColor']);
            $decorParent = Decoration::findOne(['id' => $model->product_parent_id]);
            $decorParent->trigger(Decoration::EVENT_AFTER_UPDATE);
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
            'decorations' => $model->productParents
        ]);
    }

    /**
     * Deletes an existing DecorationColor model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the DecorationColor model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return DecorationColor the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = DecorationColor::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }
}
