<?php

namespace bitcream\ndt\custom\common\models;

use Yii;
use yii\helpers\ArrayHelper;
use Emberware\Evidia\Toolkit\Model\SoftDeleteBehavior;
use bitcream\ndt\custom\common\behaviors\StatusBehaviors;
use bitcream\ndt\custom\common\behaviors\CreateUpdateBehaviors;

/**
 * This is the model common class for table "favourites".
 */
class Favourites extends base\Favourites
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
       ]);
    }

    public function fields(){
        return [
            'id',
            'bandOfDecorationId' => 'band_of_decoration_id',
            'customerUserId' => 'customer_user_id',
            'decorationColorId' => 'decoration_color_id',
        ];
    }

    /**
     * Gets query for [[BandOfDecoration]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getBandOfDecoration()
    {
        return $this->hasOne(BandOfDecoration::className(), ['id' => 'band_of_decoration_id']);
    }
    
    /**
     * Gets query for [[DecorationColor]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getDecorationColor()
    {
        return $this->hasOne(DecorationColor::className(), ['id' => 'decoration_color_id']);
    }

    public static function find(){
        return parent::find()->where([
            'status' => 30, //prodotti non cancellati
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return ArrayHelper::merge(parent::rules(), [

        ]);
    }

     /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return ArrayHelper::merge(parent::attributeLabels(), [

        ]);
    }
    
}
