<?php

namespace bitcream\ndt\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "user".
 *
 * @property int $id
 * @property string $username
 * @property string|null $name
 * @property string|null $surname
 * @property string|null $phone
 * @property string|null $access_token
 * @property string $auth_key
 * @property string $password_hash
 * @property string|null $password_reset_token
 * @property string|null $password_reset_expires
 * @property string|null $date_subscription
 * @property string $email
 * @property int $status
 * @property int $created_at
 * @property string|null $created_user_id
 * @property int $updated_at
 * @property string|null $updated_user_id
 * @property string|null $verification_token
 * @property string|null $activation_key
 *
 * @property Favourites[] $favourites
 */
class CustomerUser extends \emberware\evidia\users\common\models\User
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'user';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['username', 'email'], 'required'],
            [['status', 'created_at', 'updated_at'], 'integer'],
            [['username', 'name', 'surname', 'phone', 'access_token', 'password_hash', 'password_reset_token', 'password_reset_expires', 'date_subscription', 'email', 'created_user_id', 'updated_user_id', 'verification_token', 'activation_key'], 'string', 'max' => 255],
            [['auth_key'], 'string', 'max' => 32],
            [['username'], 'unique'],
            [['email'], 'unique'],
            [['password_reset_token'], 'unique'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'username' => Yii::t('app', 'Username'),
            'name' => Yii::t('app', 'Name'),
            'surname' => Yii::t('app', 'Surname'),
            'phone' => Yii::t('app', 'Phone'),
            'access_token' => Yii::t('app', 'Access Token'),
            'auth_key' => Yii::t('app', 'Auth Key'),
            'password_hash' => Yii::t('app', 'Password Hash'),
            'password_reset_token' => Yii::t('app', 'Password Reset Token'),
            'password_reset_expires' => Yii::t('app', 'Password Reset Expires'),
            'date_subscription' => Yii::t('app', 'Date Subscription'),
            'email' => Yii::t('app', 'Email'),
            'status' => Yii::t('app', 'Status'),
            'created_at' => Yii::t('app', 'Created At'),
            'created_user_id' => Yii::t('app', 'Created User ID'),
            'updated_at' => Yii::t('app', 'Updated At'),
            'updated_user_id' => Yii::t('app', 'Updated User ID'),
            'verification_token' => Yii::t('app', 'Verification Token'),
            'activation_key' => Yii::t('app', 'Activation Key'),
        ];
    }

    /**
     * Gets query for [[Favourites]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getFavourites()
    {
        return $this->hasMany(Favourites::className(), ['customer_user_id' => 'id']);
    }
}
