<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use kartik\select2\Select2;
/* @var $this yii\web\View */
/* @var $model bitcream\gmvricambi\custom\common\models\CustomerUser */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="customer-user-form">

    <?php $form = ActiveForm::begin(['enableClientValidation' => true]) ?>

    <?php if($model->id){ ?>
        <div class="row">
            <div class="col-md-6">
                <label> Username </label><br>
                <?= $model->username?><br>
            </div>
        </div>
        <br>
    <?php }else{ ?>
        <div class="row">
            <div class="col-md-6 col-xs-12">
                <?= $form->field($model, 'username')->textInput(['maxlength' => true]) ?>
            </div>
        </div>
    <?php } ?>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'password_hash')->textInput(['maxlength' => true])->label("Password") ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'surname')->textInput(['maxlength' => true]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'email')->textInput(['maxlength' => true]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'languages')->widget(bitcream\ndt\custom\common\widget\LanguageRadioWidget::class,[
                'languages' => $model->languages,
                'language' => $model->language,
            ])->label(Yii::t('app', 'Language'));
            ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'customerCod')->widget(Select2::classname(), [
                'name' => 'customerCod',
                'class' => 'form-group customerCods form-control',
                'value' => ArrayHelper::map($customers, 'customer_cod', function ($customer) {
                    return $customer['name'];
                }),
                'id' => 'customerCod',
                'data' => ArrayHelper::map($customers, 'customer_cod', function ($customer) {
                    return $customer['name'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select customer')]
            ])->label(Yii::t('app', 'Customer'));?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'agent')->textInput(['maxlength' => true]) ?>
        </div>
    </div>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
