<?php

namespace bitcream\ndt\custom\common\models;

use Yii;
use yii\helpers\ArrayHelper;
use bitcream\pim\custom\common\models\ProductModel;
use bitcream\pim\custom\common\models\Product;
use yii\helpers\Inflector;
use bitcream\ndt\custom\common\models\Favourites;
use bitcream\ndt\sync\wp\common\behaviors\SyncWpProductBehavior;
use bitcream\ndt\sync\wp\common\behaviors\SyncWpMediaBehavior;

/**
 * This is the model common class for table "decoration_color".
 */
class DecorationColor extends \bitcream\pim\custom\common\models\Product
{
    public static $modelParent = "decoration";
    public static $modelSlug = "decoration_color";

    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'mediaSyncStatus' => [
                'class' => SyncWpMediaBehavior::class,
                'attributes' => [
                    'preview_image',
                    'development_image',
                    'decor_in_use',
                    'thumbnail',
                ],
                'syncProperties' => [
                    'media_file' => 'getDynamicProductMediaFile',
                ]
            ],
            'files' => [
                'class' => 'floor12\files\components\FileBehaviour',
                'attributes' => [
                    'decor_in_use',
                ],
            ],
       ]);
    }

    public function fields(){
        return [
            'id',
            'title',
            'slug' => function(){
                return $this->slug;
            },
            'favoriteId' => 'favorites',
            'images' => function(){
                return [
                    'thumbnail' => (isset($this->thumbnailImage[0]))? $this->thumbnailImage[0]: "",
                    'expanded' => (isset($this->expanded[0]))? $this->expanded[0]: "",
                ];
            },
            'renders' => function(){
                return $this->renders;
            },
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return ArrayHelper::merge(parent::rules(), [
            ['decor_in_use', 'file', 'extensions' => ['jpg', 'png', 'jpeg', 'gif'], 'maxFiles' => 10],
        ]);
    }

     /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return ArrayHelper::merge(parent::attributeLabels(), [
            'decor_in_use' => Yii::t('app', 'Decor in use'),
        ]);
    }

    public function getSlug(){
        return Inflector::slug($this->title, '-');
    }

    /**
     * Gets query for [[Decoration]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getDecoration()
    {
        return $this->hasOne(Decoration::className(), ['id' => 'product_parent_id']);
    }
    
    public function getCode(){        
        return $this->getDynamicAttributeValue("code");        
    }

    public function setCode($value){        
        return $this->setDynamicAttribute("code", $value);        
    }

    public function getTemporary_code(){        
        return $this->getDynamicAttributeValue("temporary_code");        
    }

    public function setTemporary_code($value){        
        return $this->setDynamicAttribute("temporary_code", $value);        
    }

    public function getThumbnail(){        
        return $this->getDynamicAttributeValue("thumbnail");        
    }

    public function setThumbnail($value){        
        return $this->setDynamicAttribute("thumbnail", $value);        
    }

    public function setDefault_color($value){        
        return $this->setDynamicAttribute("default_color", $value);        
    }

    public function getDefault_color(){        
        return $this->getDynamicAttributeValue("default_color");        
    }
    
    public function getFavorites(){
        $favorite = Favourites::find()->where(['decoration_color_id' => $this->id, 'customer_user_id' => Yii::$app->user->id, 'status' => 30])->one();
        if(!empty($favorite)) return $favorite->id;
        return "";
    }

    public function getThumbnailImage(){
        return $this->getImageFields('thumbnail');
    }

    public function getExpanded(){
        return $this->getImageFields('development_image');
    }

    public function getRenders(){
        return $this->getImageFields('decor_in_use');
    }

    public function getImageFields(string $attribute){
        $imageFields = [];
        if(isset($this->$attribute)){
            foreach($this->$attribute as $attributeFile){
                $href = str_replace('api', 'backend', Yii::$app->params['serverName'].$attributeFile->href);
                $imageFields[] = [
                    'href' => $href,
                    'type' => $attributeFile->content_type,
                    'size' => $attributeFile->size,                   
                ];
            }
            return $imageFields;
        }
        return "";
    }
    
    public function getPreview_image(){        
        return $this->getDynamicAttributeValue("preview_image");        
    }

    public function setPreview_image($value){        
        return $this->setDynamicAttribute("preview_image", $value);        
    }

    public function getDevelopment_image(){        
        return $this->getDynamicAttributeValue("development_image");        
    }

    public function setDevelopment_image($value){        
        return $this->setDynamicAttribute("development_image", $value);        
    }

    public function getDecor_in_use(){        
        return $this->getDynamicAttributeValue("decor_in_use");        
    }

    public function setDecor_in_use($value){        
        return $this->setDynamicAttribute("decor_in_use", $value);        
    }

    public function getCategory_image(){        
        return $this->getDynamicAttributeValue("category_image");        
    }

    public function setCategory_image($value){        
        return $this->setDynamicAttribute("category_image", $value);        
    }

}
