<?php

namespace bitcream\ndt\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%collection_customer_user}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%customer_user}}`
 */
class M220331135015AddCustomerUserIdColumnToCollectionCustomerUserTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%collection_customer_user}}', 'customer_user_id', $this->integer()->null());

        // creates index for column `customer_user_id`
        $this->createIndex(
            '{{%idx-collection_customer_user-customer_user_id}}',
            '{{%collection_customer_user}}',
            'customer_user_id'
        );

        // add foreign key for table `{{%customer_user}}`
        $this->addForeignKey(
            '{{%fk-collection_customer_user-customer_user_id}}',
            '{{%collection_customer_user}}',
            'customer_user_id',
            '{{%user}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%customer_user}}`
        $this->dropForeignKey(
            '{{%fk-collection_customer_user-customer_user_id}}',
            '{{%collection_customer_user}}'
        );

        // drops index for column `customer_user_id`
        $this->dropIndex(
            '{{%idx-collection_customer_user-customer_user_id}}',
            '{{%collection_customer_user}}'
        );

        $this->dropColumn('{{%collection_customer_user}}', 'customer_user_id');
    }
}
