<?php

namespace bitcream\ndt\custom\backend\controllers;

use Yii;
use bitcream\ndt\custom\common\models\ProductTranslation;
use bitcream\ndt\custom\common\models\Decoration;
use bitcream\ndt\custom\common\models\DecorationColor;
use bitcream\ndt\custom\common\models\DecorationSearch;
use bitcream\ndt\custom\common\models\BandOfDecorationSearch;
use bitcream\pim\custom\common\models\ProductModel;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
/**
 * DecorationController implements the CRUD actions for Decoration model.
 */
class DecorationController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error'],
                        'allow' => true,
                    ],
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Decoration models.
     * @return mixed
     */
    public function actionIndex()
    {
        $productTranslation = new ProductTranslation();
        $languages = $productTranslation->getAllLanguages();
        $searchModel = new DecorationSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'languages' => $languages,
        ]);
    }

    /**
     * Displays a single Decoration model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        $bandOfDecorationSearchModel = new BandOfDecorationSearch();
        $bandOfDecorationDataProvider = $bandOfDecorationSearchModel->search(Yii::$app->request->queryParams);

        return $this->render('view', [
            'model' => $this->findModel($id),
            'bandOfDecorationDataProvider' => $bandOfDecorationDataProvider,
            'bandOfDecorationSearchModel' => $bandOfDecorationSearchModel,
        ]);
    }

    /**
     * Creates a new Decoration model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Decoration();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            $model->saveDynamicAttributes(Yii::$app->request->post()['Decoration']);            
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
            'categories' => $model->productParents
        ]);
    }

    /**
     * Updates an existing Decoration model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            $decorationValues = Yii::$app->request->post()['Decoration'];
            if(isset(Yii::$app->request->post()['ProductValue'])){
                $decorationValues['ProductValue'] = Yii::$app->request->post()['ProductValue'];
            }            
            foreach($model->decorationColors as $decorationColor){
                $decorationColor->trigger(DecorationColor::EVENT_AFTER_UPDATE);
            }     
            $model->saveDynamicAttributes($decorationValues);
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
            'categories' => $model->productParents
        ]);
    }

    /**
     * Deletes an existing Decoration model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Decoration model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Decoration the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Decoration::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }
}
