<?php

use yii\helpers\Html;
use Emberware\Evidia\Toolkit\Model\Datatable;
use Emberware\Evidia\Field\FlagIcon\FlagIcon;
?>
<div class="category-datatable">
    <?=  Datatable::widget([
            'dataProvider' => $dataProvider,
            'id' => 'category-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                ['attribute'=>Yii::t('app', 'title'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->title, [Yii::$app->controller->id.'/update','id'=>$data->id]);}
                ],
                [
                    'format'=>'raw',
                    'label' => 'Translation',
                    'value' => function ($model, $key, $index, $column) use ($languages)
                    {
                        $arrLang = array();
                        //Get product with article_cod
                        $htmlButtons = "";
                        if($model->productsTranslation){
                            foreach($model->productsTranslation as $productTranslation){
                                $lang = $productTranslation->getLanguageObject();
                                if($lang){
                                    if($lang->label == "en"){
                                        $country = "gb";
                                    }else{
                                        $country = $lang->label;
                                    }
                                    $flag = FlagIcon::widget([
                                        'countryCode' => $country,
                                        'options' => [
                                            'class' => 'flag-button'
                                        ]                            
                                    ]);

                                    array_push($arrLang, $lang->label);
                                    
                                    $htmlButtons .= " ".Html::a(Yii::t('app', '{flag} &nbsp;<i class="fa fa-pencil-square-o"></i>', ['flag' => $flag]), ['product-translation/update', 'id' => $productTranslation->id, 'product_id' => $model->id, 'controller'=>Yii::$app->controller->id], ['class' => 'btn btn-warning action-button']);
                                    $htmlButtons .= " ".Html::a(Yii::t('app', '{flag} &nbsp;<i class="fa fa-times"></i>', ['flag' => $flag]), ['product-translation/delete', 'id'=> $productTranslation->id, 'controller'=>Yii::$app->controller->id], 
                                        [
                                            'class' => 'btn btn-danger action-button',
                                            'data' => [
                                                'confirm' => Yii::t('app','Are you sure you want to delete this decoration?'),
                                                'method' => 'post',
                                            ]
                                        ]);
                                }
                            }
                        }

                        foreach($languages as $language) 
                        {
                            if (!in_array($language, $arrLang)) {
                                if($language == "en"){
                                    $country = "gb";
                                }else{
                                    $country = $language;
                                }
                                $flag = FlagIcon::widget([
                                    'countryCode' => $country,
                                    'options' => [
                                        'class' => 'flag-button'
                                    ]                            
                                ]);
                                $htmlButtons .= " ".Html::a(Yii::t('app', '{flag} &nbsp;<i class="fa fa-plus"></i>', ['flag' => $flag]), ['product-translation/create', 'lang_create' => $language, 'product_id' => $model->id, 'controller'=>Yii::$app->controller->id], ['class' => 'btn btn-success action-button']);
                            }
                        }

                        return $htmlButtons;
                       
                    }
                ],
                [
                    'class' => '\yii\grid\ActionColumn',
                    'header' => Yii::t('app', 'Actions'),
                    'visibleButtons' => ['delete' => true, 'update' => false, 'view' => false],
                ]
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('app',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
     ?>

</div>