<?php

use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;

?>
<div class="favourites-datatable">
    <?=        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                ['attribute'=>Yii::t('app', 'Customer user'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return $data->customerUser->name." ".$data->customerUser->surname;}
                ],
                ['attribute'=>Yii::t('app', 'Band of decoration'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return $data->bandOfDecoration->title;}
                ],
                ['attribute'=>Yii::t('app', 'Decoration color'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return $data->decorationColor->title;}
                ],
                [
                    'class' => '\yii\grid\ActionColumn',
                    'header' => Yii::t('app', 'Actions'),
                    'visibleButtons' => ['delete' => true, 'update' => false, 'view' => false],
                ]
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('app',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
     ?>

</div>