<?php

namespace bitcream\ndt\custom\common\models;

use Yii;
use yii\helpers\ArrayHelper;
use Emberware\Evidia\Toolkit\Model\SoftDeleteBehavior;
use bitcream\ndt\custom\common\behaviors\StatusBehaviors;
use bitcream\ndt\custom\common\behaviors\CreateUpdateBehaviors;
use bitcream\pim\custom\common\models\Product; 

/**
 * This is the model common class for table "band_of_decoration".
 */
class BandOfDecoration extends base\BandOfDecoration
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
            'files' => [
                'class' => 'floor12\files\components\FileBehaviour',
                'attributes' => [
                    'layout_img_1',
                    'layout_img_2',
                    'layout_img_3',
                ],
            ],
            'slug' => [
                'class' => 'skeeks\yii2\slug\SlugBehavior',
                'slugAttribute' => 'slug',                      //The attribute to be generated
                'attribute' => 'title',       
                'slugifyOptions' => [
                    //'lowercase' => true,
                    'separator' => '-',
                    //'trim' => true
                    //'regexp' => '/([^A-Za-z0-9]|-)+/',
                    //'rulesets' => ['russian'],
                    //@see all options https://github.com/cocur/slugify
                ]
            ],
       ]);
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return ArrayHelper::merge(parent::rules(), [
            ['title', 'required'],
            ['layout_img_1', 'file', 'extensions' => ['jpg', 'png', 'jpeg', 'gif'], 'maxFiles' => 1],
            ['layout_img_2', 'file', 'extensions' => ['jpg', 'png', 'jpeg', 'gif'], 'maxFiles' => 1],
            ['layout_img_3', 'file', 'extensions' => ['jpg', 'png', 'jpeg', 'gif'], 'maxFiles' => 1],
        ]);
    }

     /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return ArrayHelper::merge(parent::attributeLabels(), [
            'layout_img_1' => Yii::t('app', 'Layout image 1'),
            'layout_img_2' => Yii::t('app', 'Layout image 2'),
            'layout_img_3' => Yii::t('app', 'Layout image 3'),
        ]);
    }

    public static function find(){
        return parent::find()->where([
            'status' => 30, //prodotti non cancellati
        ]);
    }

    /**
     * Gets query for [[Decoration]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getDecoration()
    {
        return $this->hasOne(Decoration::className(), ['id' => 'decoration_id'])->andWhere(['status' => '30']);
    }

    /**
     * Gets query for [[Collection]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCollection()
    {
        return $this->hasOne(Collection::className(), ['id' => 'collection_id']);
    }

    /**
     * Gets query for [[BandOfDecorationColors]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getBandOfDecorationColors()
    {
        return $this->hasMany(BandOfDecorationColor::className(), ['band_of_decoration_id' => 'id'])->andWhere(['status' => '30']);
    }

    public function fields(){
        return [
            'id',
            'collectionId' => 'collection_id',
            'title',
            'slug',
            'introductionText' => 'introduction_text',
            'decoration' => 'decoration', 
            'intendedUse' => function(){
                return $this->intended_use;
            },
            'moodboard' => 'moodboard',
            'decorationColor' => 'decorationColors',
            'downloads' => function(){ 
                if(isset($this->decoration->downloads[0])) return $this->decoration->downloads[0];
                return "";
            },
        ];
    }

     /**
     * Gets query for [[DecorationColor]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getMoodboard()
    {
        $bandOfDecoration = BandOfDecoration::findOne(['id' => $this->id]);
        if(isset($bandOfDecoration)){
            return [
                'layout' => (!empty($bandOfDecoration->layout))? 'layout-'.$bandOfDecoration->layout : "",
                'layoutImage1' => $bandOfDecoration->layout_image_1,
                'layoutImage2' => $bandOfDecoration->layout_image_2,
                'layoutImage3' => $bandOfDecoration->layout_image_3,
            ];
        }
        return "";
    }

    public function getDecorationColors(){
        if(!empty($this->bandOfDecorationColors)){
            return $this->bandOfDecorationColors;
        }else{
            return $this->decoration->decorationColors;
        }
    }

}
