<?php

namespace bitcream\ndt\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%favourites}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%collection}}`
 */
class M220128110007AddCollectionIdColumnToFavouritesTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%favourites}}', 'collection_id', $this->integer()->null());

        // creates index for column `collection_id`
        $this->createIndex(
            '{{%idx-favourites-collection_id}}',
            '{{%favourites}}',
            'collection_id'
        );

        // add foreign key for table `{{%collection}}`
        $this->addForeignKey(
            '{{%fk-favourites-collection_id}}',
            '{{%favourites}}',
            'collection_id',
            '{{%collection}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%collection}}`
        $this->dropForeignKey(
            '{{%fk-favourites-collection_id}}',
            '{{%favourites}}'
        );

        // drops index for column `collection_id`
        $this->dropIndex(
            '{{%idx-favourites-collection_id}}',
            '{{%favourites}}'
        );

        $this->dropColumn('{{%favourites}}', 'collection_id');
    }
}
