<?php

namespace bitcream\ndt\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles dropping columns from table `{{%favourites}}`.
 */
class M220225130045DropCollectionIdColumnFromFavouritesTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
         // drops foreign key for table `{{%band_of_decoration}}`
         $this->dropForeignKey(
            '{{%fk-favourites-collection_id}}',
            '{{%favourites}}'
        );

        // drops index for column `band_of_decoration_id`
        $this->dropIndex(
            '{{%idx-favourites-collection_id}}',
            '{{%favourites}}'
        );

        $this->dropColumn('{{%favourites}}', 'collection_id');
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->addColumn('{{%favourites}}', 'collection_id', $this->integer());
    }
}
