<?php

namespace bitcream\ndt\custom\common\models;

use Yii;
use yii\helpers\ArrayHelper;
use bitcream\pim\custom\common\models\Product;
use bitcream\ndt\custom\common\models\CustomerUser;
use bitcream\pim\custom\common\models\Attribute;
use bitcream\pim\custom\common\models\ProductValue;
use bitcream\ndt\custom\common\models\ProductTranslation;
use yii\helpers\Inflector;
use bitcream\ndt\sync\wp\common\behaviors\SyncWpProductBehavior;
use bitcream\ndt\sync\wp\common\behaviors\SyncWpTaxonomyBehavior;
use bitcream\ndt\sync\wp\common\behaviors\SyncWpMediaBehavior;
use bitcream\ndt\sync\wp\common\behaviors\SyncWpProductTranslationBehavior;
/**
 * This is the extended model class for table "{{%product}}".
 */
class Decoration extends \bitcream\pim\custom\common\models\Product
{    
    public static $modelParent = "category";
    public static $modelSlug = "decoration";

    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'productSyncStatus' => [
                'class' => SyncWpProductBehavior::class,
                'attributes' => [
                    'self',
                ],
                'syncProperties' => [
                    'title' => 'title',
                    'description' => 'description',
                    'meta' => 'wpMeta',
                    'terms' => 'wpTerms',
                ]
            ],
            'taxonomySyncStatus' => [
                'class' => SyncWpTaxonomyBehavior::class,
                'attributes' => [
                    'decors-category',
                    'new_in',
                    'highlights',
                    'development',
                    'maximum_print_height',                    
                    'number_of_cylinders',
                    'metallic_effect',
                    'touch_effect',
                    'features',
                    'intended_use',
                ],
                'syncProperties' => [
                    'taxonomy' => 'getTaxonomyFromAttribute', 
                ]
            ],
            'mediaSyncStatus' => [
                'class' => SyncWpMediaBehavior::class,
                'attributes' => [
                    'preview_image',
                    'download_file_product',
                ],
                'syncProperties' => [
                    'media_file' => 'getDynamicProductMediaFile',
                ]
            ],
            'translationSyncStatus' => [
                'class' => SyncWpProductTranslationBehavior::class,
                'attributes' => [
                    'en',
                ],
                'syncProperties' => [
                    'post_id' => 'getTranslationId',
                    'title' => 'getTranslatedTitle',
                    'description' => 'getTranslatedDescription',
                    'language' => 'getTranslatedLanguage',
                    //'terms' => 'wpTermsTranslation',
                ]
            ],
       ]);
    }

    public function getWpMeta(){
        return [
            '_codice' => $this->code,
            '_codice_temporaneo' => $this->temporary_code,
            '_thumbnail_id' => (!empty($this->getMediaObject('preview_image')))? $this->getMediaObject('preview_image')->remote_object: "",
            '_tinte' => $this->decorationColorsMeta,
        ];
    }

    public function attributeLabels()
    {
        return ArrayHelper::merge(parent::attributeLabels(), [
            'default_decoration_color' => Yii::t('app', 'Tinta predefinita'),
            'code' => Yii::t('app', 'Codice'),
            'temporary_code' => Yii::t('app', 'Codice temporaneo'),
            'new_in' => Yii::t('app', 'Novità'),
            'highlights' => Yii::t('app', 'In evidenza'),
            'development' => Yii::t('app', 'Sviluppo'),
            'maximum_print_height' => Yii::t('app', 'Altezza massima di stampa'),
            'number_of_cylinders' => Yii::t('app', 'Numero di cilindri'),
            'metallic_effect' => Yii::t('app', 'Effetto metallico'),
            'touch_effect' => Yii::t('app', 'Effetto touch'),
            'features' => Yii::t('app', 'Caratteristiche'),
            'download_file_product' => Yii::t('app', 'File download del prodotto'),
            'intended_use' => Yii::t('app', 'Destinazione d\'uso'),
        ]);
    }

    public function getWpTerms(){
        return [
            "decors-category" => $this->getTaxonomyRemoteObjects('decors-category'), 
            'new_in' => $this->getTaxonomyRemoteObjects('new_in'),
            'highlights' => $this->getTaxonomyRemoteObjects('highlights'),
            'development' => $this->getTaxonomyRemoteObjects('development'),
            'maximum_print_height' => $this->getTaxonomyRemoteObjects('maximum_print_height'),
            'number_of_cylinders' => $this->getTaxonomyRemoteObjects('number_of_cylinders'),
            'metallic_effect' => $this->getTaxonomyRemoteObjects('metallic_effect'),
            'touch_effect' => $this->getTaxonomyRemoteObjects('touch_effect'),
            'features' => $this->getTaxonomyRemoteObjects('features'),
            'intended_use' => $this->getTaxonomyRemoteObjects('intended_use'),
        ];
    }


    public function getWpDecorsCategoryMeta(){
        //da inserire ciclo per generare l'array delle category
        return [
            'id' => 18,
            'meta' => [
                '_thumbnail_id' => (!empty($this->getMediaObject('category_image')))? $this->getMediaObject('category_image')->remote_object: ""
            ]            
        ];
    }

    public function getTaxonomyFromAttribute(string $attribute){
        if($attribute == 'decors-category'){
            $response = [
                'name' => 'Categorie decori',
                'slug' => 'decors-category',
                'terms' => [$this->productParent->title]
            ];
            return $response;
        }

        $productValue = $this->getDynamicProductValue($attribute);
        $response = [
            'name' => $productValue->attributeObject->title,
            'slug' => $productValue->attributeObject->slug,
        ];

        $value = $productValue->value;
        if(@unserialize($value) == true){
            $value = unserialize($value);
        }

        if(is_array($value)){
            $response['terms'] = $value;
        }else{
            $response['term'] = $value;
        }
        return $response;
    }

    public function getDecorationColorsMeta(){
        $decorationColorsMeta = [];
        if(!isset($this->decorationColors)) return;
        foreach($this->decorationColors as $decorationColor){
            $decorationColorsMeta[] = [
                "_codice" => $decorationColor->code,
                "_codice_temporaneo" => $decorationColor->temporary_code,
                "_immagine_di_anteprima_media_id" => (!empty($decorationColor->getMediaObject('preview_image')))? $decorationColor->getMediaObject('preview_image')->remote_object: "",
                "_decore_in_use_media_ids" => (!empty($decorationColor->getGalleryMediaObjects('decor_in_use')))? $decorationColor->getGalleryMediaObjects('decor_in_use'): [],
                "_immagine_sviluppo_media_id" => (!empty($decorationColor->getMediaObject('development_image')))? $decorationColor->getMediaObject('development_image')->remote_object: "",
                "_thumbnail" =>  (!empty($decorationColor->getMediaObject('thumbnail')))? $decorationColor->getMediaObject('thumbnail')->remote_object: "", 
            ];
        }
        return $decorationColorsMeta;
    }
    
    public function fields(){
        return [
            'id',
            'title' => function(){
                return $this->getTitle();
            },
            'slug' => 'slug',
            'code' => 'code',
            'description' => function(){
                return $this->getDescription();
            },
            'decorationInfo' => function(){
                return [ 
                    'development' => $this->development,          
                    'maximumPrintHeight' => (int)$this->maximum_print_height,
                    'numberOfCylinders' => (int)$this->number_of_cylinders,
                    'metallicEffect' => (bool)$this->metallic_effect,
                    'touchEffect' => (bool)$this->touch_effect,
                    'features' => $this->features,
                ];
            }, 
        ];
    }

    public function getSelectedColor(){
        if(empty($this->decorationColors)) return;
        foreach($this->decorationColors as $decorationColor ){
            if(!empty($decorationColor->default_color)) return $decorationColor;
        }
        return $this->decorationColors[0];
    }

    public function getPreview_image(){
        if(empty($this->selectedColor)) return;
        return $this->selectedColor->category_image;
    }

    public function getCategory_image(){
        return $this->category->cover_image;
    }

    /**
     * Gets query for [[DecorationColor]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getDecorationColors()
    {
        return $this->hasMany(DecorationColor::className(), ['product_parent_id' => 'id'])->andWhere(['status' => '30']);
    }

    /**
     * Gets query for [[Category]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCategory()
    {
        return Category::findOne($this->productParent->id);
    }

    public function getSlug(){
        return Inflector::slug($this->title, '-');
    }

    public function getCode(){        
        return $this->getDynamicAttributeValue("code");        
    }

    public function setCode($value){        
        return $this->setDynamicAttribute("code", $value);        
    }

    public function getTemporary_code(){        
        return $this->getDynamicAttributeValue("temporary_code");        
    }

    public function setTemporary_code($value){        
        return $this->setDynamicAttribute("temporary_code", $value);        
    }

    public function getColor(){        
        return $this->getDynamicAttributeValue("color");        
    }

    public function setColor($value){        
        return $this->setDynamicAttribute("color", $value);        
    }

    public function getNew_in(){        
        return $this->getDynamicAttributeValue("new_in");        
    }

    public function setNew_in($value){        
        return $this->setDynamicAttribute("new_in", $value);        
    }

    public function getHighlights(){        
        return $this->getDynamicAttributeValue("highlights");        
    }

    public function setHighlights($value){        
        return $this->setDynamicAttribute("highlights", $value);        
    }

    public function getDevelopment(){        
        return $this->getDynamicAttributeValue("development");        
    }

    public function setDevelopment($value){        
        return $this->setDynamicAttribute("development", $value);        
    }

    public function getMaximum_print_height(){        
        return $this->getDynamicAttributeValue("maximum_print_height");        
    }

    public function setMaximum_print_height($value){        
        return $this->setDynamicAttribute("maximum_print_height", $value);        
    }

    public function getNumber_of_cylinders(){        
        return $this->getDynamicAttributeValue("number_of_cylinders");        
    }

    public function setNumber_of_cylinders($value){        
        return $this->setDynamicAttribute("number_of_cylinders", $value);        
    }

    public function getMetallic_effect(){        
        return $this->getDynamicAttributeValue("metallic_effect");        
    }

    public function setMetallic_effect($value){        
        return $this->setDynamicAttribute("metallic_effect", $value);        
    }

    public function getTouch_effect(){        
        return $this->getDynamicAttributeValue("touch_effect");        
    }

    public function setTouch_effect($value){        
        return $this->setDynamicAttribute("touch_effect", $value);        
    }

    public function getFeatures(){        
        return $this->getDynamicAttributeValue("features");        
    }

    public function setFeatures($value){        
        return $this->setDynamicAttribute("features", $value);        
    }

    public function getIntended_use(){        
        return $this->getDynamicAttributeValue("intended_use");        
    }

    public function setIntended_use($value){        
        return $this->setDynamicAttribute("intended_use", $value);        
    }

    public function getOnline_from(){        
        return $this->getDynamicAttributeValue("online_from");        
    }

    public function setOnline_from($value){        
        return $this->setDynamicAttribute("online_from", $value);        
    }

    public function getOnline_to(){        
        return $this->getDynamicAttributeValue("online_to");        
    }

    public function setOnline_to($value){        
        return $this->setDynamicAttribute("online_to", $value);        
    }


    // public function getPreview_image(){        
    //     return $this->getDynamicAttributeValue("preview_image");        
    // }

    // public function setPreview_image($value){        
    //     return $this->setDynamicAttribute("preview_image", $value);        
    // }

    // public function getDevelopment_image(){        
    //     return $this->getDynamicAttributeValue("development_image");        
    // }

    // public function setDevelopment_image($value){        
    //     return $this->setDynamicAttribute("development_image", $value);        
    // }

    public function getDownloads(){
        return $this->getImageFields('download_file_product');
    }

    public function getDownload_file_product(){        
        return $this->getDynamicAttributeValue("download_file_product");        
    }

    public function setDownload_file_product($value){        
        return $this->setDynamicAttribute("download_file_product", $value);        
    }  
    
    /**
     * Riscrittura della funzione in product per predere la preview image
     * TODO: da generalizzare
     * @return array|false
     */
    public function getDynamicProductMediaFile(string $attribute){
        $media = [];
        if(empty($this->$attribute)) return false;
        foreach($this->$attribute as $file){
            $media[] = [
                'filename' => $file->title,
                'path' => Yii::getAlias('@app/storage').$file->filename
            ];
        }        
        return $media;
    }    

    public function getImageFields(string $attribute){
        $imageFields = [];
        if(isset($this->$attribute)){
            foreach($this->$attribute as $attributeFile){
                $href = str_replace('api', 'backend', Yii::$app->params['serverName'].$attributeFile->href);
                $imageFields[] = [
                    'href' => $href,
                    'type' => $attributeFile->content_type,
                    'size' => $attributeFile->size,                   
                ];
            }
            return $imageFields;
        }
        return "";
    }

    public function getTitle(){
        $products = ProductTranslation::find()->where(['product_id' => $this->id, 'status' => '30'])->all();
        if(!empty($products)){
            $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        }  
        if(!empty($customerUser)){
            $language = $customerUser->language;
        }
        if(!empty($language)){
            $productTranslation = ProductTranslation::getTranslation($language, $products); 
            if(!empty($productTranslation))
                return $productTranslation->title;
        }  
        return $this->title;
    }

    public function getDescription(){
        $products = ProductTranslation::find()->where(['product_id' => $this->id, 'status' => '30'])->all();
        if(!empty($products)){
            $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        }  
        if(!empty($customerUser)){
            $language = $customerUser->language;
        }
        if(!empty($language)){
            $productTranslation = ProductTranslation::getTranslation($language, $products); 
            if(!empty($productTranslation))
                return $productTranslation->description;
        }  

        return $this->description;
    }

    /**
     * Gets query for [[Products]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProductsTranslation()
    {
        return $this->hasMany(ProductTranslation::className(), ['product_id' => 'id']);
    }

    public function getWpTranslations(){
        $translations = [];
        foreach($this->productTranslation as $productTranslation){
            $translations = [
                'language' => $productTranslation->getLanguageObject(),
                'title' => $productTranslation->title,
                'description' => $productTranslation->description,                
            ];
        }
        return $translations;
    }

    
    public function getTranslationId(){
        return (int)$this->getSyncObject('self')->remote_object;
    }

    public function getTranslatedTitle(string $language){
        CustomerUser::setUserLanguage($language);
        return $this->getTitle();
    }

    public function getTranslatedDescription(string $language){
        CustomerUser::setUserLanguage($language);
        return $this->getDescription();
    }

    public function getTranslatedLanguage(string $language){
        return $language;
    }
}