<?php

namespace bitcream\ndt\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%collection_customer_user}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%collection}}`
 */
class M220331123415AddCollectionIdColumnToCollectionCustomerUserTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%collection_customer_user}}', 'collection_id', $this->integer()->null());

        // creates index for column `collection_id`
        $this->createIndex(
            '{{%idx-collection_customer_user-collection_id}}',
            '{{%collection_customer_user}}',
            'collection_id'
        );

        // add foreign key for table `{{%collection}}`
        $this->addForeignKey(
            '{{%fk-collection_customer_user-collection_id}}',
            '{{%collection_customer_user}}',
            'collection_id',
            '{{%collection}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%collection}}`
        $this->dropForeignKey(
            '{{%fk-collection_customer_user-collection_id}}',
            '{{%collection_customer_user}}'
        );

        // drops index for column `collection_id`
        $this->dropIndex(
            '{{%idx-collection_customer_user-collection_id}}',
            '{{%collection_customer_user}}'
        );

        $this->dropColumn('{{%collection_customer_user}}', 'collection_id');
    }
}
