<?php
namespace bitcream\ndt\custom\common\widget;

use yii\widgets\InputWidget;
use yii\helpers\Html;
use Yii;
use bitcream\ndt\custom\common\widget\AssetWidget;

class LanguageWidget extends InputWidget
{
    public $languages;

    public function init()
    {
        parent::init();
        AssetWidget::register($this->getView());
    }

    public function run()
    {
        $setLanguage = false;
        $fieldLanguages = "";

        $fieldLanguages .= "<div class='checkbox'>";
        foreach($this->languages as $language){

            $fieldLanguages .= "<label class='checkbox-inline'>";
            if($language["value"] == true){
                $setLanguage = true;
                $fieldLanguages .= "<input type='checkbox' id='checkbox-".$language["language"]."' value='".$language["language"]."' checked='checked' name='language_check[]'>";
            }else{
                $fieldLanguages .= "<input type='checkbox' id='checkbox-".$language["language"]."' value='".$language["language"]."' name='language_check[]'>";
            }  
            if(!$setLanguage && $language["language"] == "en"){
                $fieldLanguages .= "<input type='checkbox' id='checkbox-".$language["language"]."' value='".$language["language"]."' checked='checked' name='language_check[]'>";
            }              
            $fieldLanguages .= "<label for='checkbox-".$language["language"]."' class='label-language'>".$language["language"]."</label>";
            $fieldLanguages .= "</label>";
        }
        $fieldLanguages .= "</div>";
        return $fieldLanguages;
    }
}
