<?php

namespace bitcream\ndt\custom\backend\controllers;

use Yii;
use bitcream\ndt\custom\common\models\Collection;
use bitcream\ndt\custom\common\models\CollectionSearch;
use bitcream\ndt\custom\common\models\BandOfDecorationSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use bitcream\ndt\custom\common\models\CustomerUser;
use yii\filters\AccessControl;
/**
 * CollectionController implements the CRUD actions for Collection model.
 */
class CollectionController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error'],
                        'allow' => true,
                    ],
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Collection models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new CollectionSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Collection model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        $bandOfDecorationsearchModel = new BandOfDecorationSearch();
        $dataProviderBandOfDecoration = $bandOfDecorationsearchModel->search(Yii::$app->request->queryParams);

        return $this->render('view', [
            'model' => $this->findModel($id),
            'bandOfDecorationsearchModel' => $bandOfDecorationsearchModel,
            'dataProviderBandOfDecoration' => $dataProviderBandOfDecoration,
        ]);
    }

    /**
     * Creates a new Collection model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $customerUserIds = [];
        $model = new Collection();

        if ($model->load(Yii::$app->request->post())) {
            if($model->cover_image){
                $model->cover = Yii::$app->params['serverName'].$model->cover_image[1]->href;     
            }
            if(isset(Yii::$app->request->post()['customer_user_ids'])){
                $customerUserIds = Yii::$app->request->post()['customer_user_ids'];
            }           
            $model->saveCustomerUser($customerUserIds);
            $model->save();
            return $this->redirect(['index']);
        }

        return $this->render('create', [
            'model' => $model,
            'customerUsers' => CustomerUser::getAllCustomerUsers(),
        ]);
    }

    /**
     * Updates an existing Collection model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $customerUserIds = [];
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {
            if($model->cover_image && $model->cover_image[1]){
                $model->cover = Yii::$app->params['serverName'].$model->cover_image[1]->href;     
            }else{
                $model->cover = "";
            }
            if(isset(Yii::$app->request->post()['customer_user_ids'])){
                $customerUserIds = Yii::$app->request->post()['customer_user_ids'];
            }           
            $model->saveCustomerUser($customerUserIds);
            $model->save();
            return $this->redirect(['index']);
        }

        return $this->render('update', [
            'model' => $model,
            'customerUsers' => CustomerUser::getAllCustomerUsers(),
        ]);
    }

    public function actionDuplicate($id){
        $model = $this->findModel($id); 
        $duplicatedModel = $model->duplicate();
        return $this->redirect(['update', 'id' => $duplicatedModel->id]);
    }

    /**
     * Deletes an existing Collection model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Collection model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Collection the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Collection::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }
}
