<?php

use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;

?>
<div class="decoration-color-datatable">
    <?=        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                ['attribute'=>Yii::t('app', 'title'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->title, [Yii::$app->controller->id.'/update','id'=>$data->id]);}
                ],
                ['attribute'=>Yii::t('app', 'Decoration'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return (isset($data->productParent)? $data->productParent->title: "");}
                ],
                [
                    'class' => '\yii\grid\ActionColumn',
                    'header' => Yii::t('app', 'Actions'),
                    'visibleButtons' => ['delete' => true, 'update' => false, 'view' => false],
                ]
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('app',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
     ?>

</div>