<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model bitcream\ndt\custom\common\models\ProductTranslation */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="product-translation-form">

    <?php $form = ActiveForm::begin(); ?>

        <?= $form->field($model, 'product_id')->hiddenInput(['value'=> $product_id])->label(false); ?>
        <div class="row">
            <div class="col-md-6 col-xs-12">
                <?= $form->field($model, 'languages')->widget(bitcream\ndt\custom\common\widget\LanguageFlagWidget::class,[
                    'languages' => $model->languages,
                ])->label(Yii::t('app', 'Language'));
                ?>
            </div>
        </div>
        <div class='row'>
            <div class='col-md-6 col-xs-12'>
                <?= $form->field($model, 'title')->textInput(['maxlength' => true]) ?>

            </div>
        </div>

        <div class='row'>
            <div class='col-md-6 col-xs-12'>
                <?= $form->field($model, 'description')->textarea(['rows' => 6]) ?>

            </div>
        </div>

    <div class="form-group">
        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
