<?php

namespace bitcream\ndt\custom\common\models;

use Yii;
use yii\helpers\ArrayHelper;
use Emberware\Evidia\Toolkit\Model\SoftDeleteBehavior;
use bitcream\ndt\custom\common\behaviors\StatusBehaviors;
use bitcream\ndt\custom\common\behaviors\CreateUpdateBehaviors;
use yii\helpers\Inflector;
use floor12\files\models\File;
/**
 * This is the model common class for table "collection".
 */
class Collection extends base\Collection
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
            'files' => [
                'class' => 'floor12\files\components\FileBehaviour',
                'attributes' => [
                    'cover_image',
                ],
            ],
            'slug' => [
                'class' => 'skeeks\yii2\slug\SlugBehavior',
                'slugAttribute' => 'slug',                      //The attribute to be generated
                'attribute' => 'title',  
                'ensureUnique' => false,     
                'slugifyOptions' => [
                    //'lowercase' => true,
                    'separator' => '-',
                    //'trim' => true
                    //'regexp' => '/([^A-Za-z0-9]|-)+/',
                    //'rulesets' => ['russian'],
                    //@see all options https://github.com/cocur/slugify
                ]
            ],
       ]);
    }

    public static function find(){
        return parent::find()->where([
            'status' => 30, //prodotti non cancellati
        ]);
    }
    
    /**
     * Gets query for [[BandOfDecorations]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getBandOfDecorations()
    {
        return $this->hasMany(BandOfDecoration::className(), ['collection_id' => 'id'])->andWhere(['status' => '30']);
    }


    public function fields(){
        return [
            'id',
            'title',
            'slug',
            'description',            
            'cover',                
            'creationDate' => 'created_at',       
            'decorsRow' => 'bandOfDecorations',
        ];
    }

    public function getSlug(){
        return Inflector::slug($this->title, '-');
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return ArrayHelper::merge(parent::rules(), [
            ['cover_image', 'file', 'extensions' => ['jpg', 'png', 'jpeg', 'gif'], 'maxFiles' => 1],
          ]);
    }

     /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return ArrayHelper::merge(parent::attributeLabels(), [
            'cover_image' => Yii::t('app', 'Cover'),
        ]);
    }

    /**
     * save CustomerUser
     */
    public function saveCustomerUser($customerUserIds)
    {
        CollectionCustomerUser::deleteAll(['collection_id' => $this->id]);
        if (is_array($customerUserIds)) {
            foreach($customerUserIds as $customerUserId) {
                $collectionCustomerUser = new CollectionCustomerUser();
                $collectionCustomerUser->collection_id = $this->id;
                $collectionCustomerUser->customer_user_id = $customerUserId;
                $collectionCustomerUser->save();
            }
        }
    }

    public function duplicate(){
        //$customers = [];
        //duplicate collection
        $copyCollection = clone $this;
        $copyCollection->isNewRecord = true;
        foreach ($this->getPrimaryKey(true) as $field => $value) {
            unset($copyCollection->{$field});
        }
        $copyCollection->title = Yii::t('app', 'Copy of')." ".$this->title;
        $copyCollection->status = "30";
        $copyCollection->created_at = (string)time();
        $copyCollection->updated_at = (string)time();
        $copyCollection->save();

        $files = $this->files;
        if(!empty($files)){
            foreach($files as $file){
                $cloneFile = new File;
                $cloneFile->attributes = $file->attributes;
                $cloneFile->object_id = $copyCollection->id;
                $cloneFile->size = $file->size;
                $cloneFile->created = (string)time();
                $cloneFile->save();
            }
        }
        
        //link customer
        // $customerUsers = $this->customerUsers;
        // foreach($customerUsers as $customerUser){
        //     array_push($customers, $customerUser->id);
        // }
        // $this->saveCustomerUser($customers, $copyCollection);

        $bandOfDecorations = $this->bandOfDecorations;
        if(!empty($bandOfDecorations)){
            foreach($bandOfDecorations as $bandOfDecoration){
                $cloneBandOfDecoration = new BandOfDecoration;
                $cloneBandOfDecoration->attributes = $bandOfDecoration->attributes;
                $cloneBandOfDecoration->collection_id = $copyCollection->id;
                $cloneBandOfDecoration->created_at = (string)time();
                $cloneBandOfDecoration->updated_at = (string)time();
                $cloneBandOfDecoration->save();  
                
                $filesBand = $bandOfDecoration->files;
                if(!empty($filesBand)){
                    foreach($filesBand as $fileBand){
                        $clonefileBand = new File;
                        $clonefileBand->attributes = $fileBand->attributes;
                        $clonefileBand->object_id = $cloneBandOfDecoration->id;
                        $clonefileBand->created = (string)time();
                        $clonefileBand->size = $fileBand->size;
                        $clonefileBand->save();
                    }
                }

                $bandOfDecorationColors = $bandOfDecoration->bandOfDecorationColors;
                if(!empty($bandOfDecorationColors)){
                    foreach($bandOfDecorationColors as $bandOfDecorationColor){
                        $cloneBandOfDecorationColor = new BandOfDecorationColor;
                        $cloneBandOfDecorationColor->attributes = $bandOfDecorationColor->attributes;
                        $cloneBandOfDecorationColor->band_of_decoration_id = $cloneBandOfDecoration->id;
                        $cloneBandOfDecorationColor->created_at = (string)time();
                        $cloneBandOfDecorationColor->updated_at = (string)time();
                        $cloneBandOfDecorationColor->save();  
                    }
                } 
            }
        }
        return $copyCollection;        
    }

    public function getFiles(){
        $files = File::find()
                    ->where(['object_id' => $this->id, 'class' => self::class])
                    ->all();
        return $files;
    }
    
}
