<?php

namespace bitcream\ndt\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%favourites}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%band_of_decoration}}`
 */
class M220225125955AddBandOfDecorationIdColumnToFavouritesTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%favourites}}', 'band_of_decoration_id', $this->integer()->null());

        // creates index for column `band_of_decoration_id`
        $this->createIndex(
            '{{%idx-favourites-band_of_decoration_id}}',
            '{{%favourites}}',
            'band_of_decoration_id'
        );

        // add foreign key for table `{{%band_of_decoration}}`
        $this->addForeignKey(
            '{{%fk-favourites-band_of_decoration_id}}',
            '{{%favourites}}',
            'band_of_decoration_id',
            '{{%band_of_decoration}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%band_of_decoration}}`
        $this->dropForeignKey(
            '{{%fk-favourites-band_of_decoration_id}}',
            '{{%favourites}}'
        );

        // drops index for column `band_of_decoration_id`
        $this->dropIndex(
            '{{%idx-favourites-band_of_decoration_id}}',
            '{{%favourites}}'
        );

        $this->dropColumn('{{%favourites}}', 'band_of_decoration_id');
    }
}
