<?php

namespace bitcream\ndt\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%favourites}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%product}}`
 */
class M220221125436AddDecorationColorIdColumnToFavouritesTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%favourites}}', 'decoration_color_id', $this->integer()->null());

        // creates index for column `decoration_color_id`
        $this->createIndex(
            '{{%idx-favourites-decoration_color_id}}',
            '{{%favourites}}',
            'decoration_color_id'
        );

        // add foreign key for table `{{%product}}`
        $this->addForeignKey(
            '{{%fk-favourites-decoration_color_id}}',
            '{{%favourites}}',
            'decoration_color_id',
            '{{%product}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%product}}`
        $this->dropForeignKey(
            '{{%fk-favourites-decoration_color_id}}',
            '{{%favourites}}'
        );

        // drops index for column `decoration_color_id`
        $this->dropIndex(
            '{{%idx-favourites-decoration_color_id}}',
            '{{%favourites}}'
        );

        $this->dropColumn('{{%favourites}}', 'decoration_color_id');
    }
}
