<?php
namespace bitcream\ndt\custom\common\widget;

use yii\widgets\InputWidget;
use yii\helpers\Html;
use Yii;
use bitcream\ndt\custom\common\widget\AssetWidget;

class LanguageRadioWidget extends InputWidget
{
    public $languages;
    public $language;

    public function init()
    {
        parent::init();
        AssetWidget::register($this->getView());
    }

    public function run()
    {
        $setLanguage = false;
        $fieldLanguages = "";

        $fieldLanguages .= "<div class='radio'>";
        foreach($this->languages as $language){

            $fieldLanguages .= "<label class='radio-inline'>";
            if($this->language == $language["language"]){
                $fieldLanguages .= "<input type='radio' id='radio-".$language["language"]."' value='".$this->language."' checked='checked' name='language_check[]'>";
            }else{
                $fieldLanguages .= "<input type='radio' id='radio-".$language["language"]."' value='".$language["language"]."' name='language_check[]'>";
            }          
            $fieldLanguages .= "<label for='radio-".$language["language"]."' class='label-language'>".$language["language"]."</label>";
            $fieldLanguages .= "</label>";
        }
        $fieldLanguages .= "</div>";
        return $fieldLanguages;
    }
}
