<?php

use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;
use yii\helpers\Url;
?>
<div class="band-of-decoration-datatable">
    <?= DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'rowOptions' => function ($model, $key, $index, $grid) {
                return ['data-sortable-id' => $model->id];
            },
            'columns' => [
                [
                    'class' => \kotchuprik\sortable\grid\Column::className(),
                ],
                ['attribute'=>Yii::t('app', 'Title'),
                    'format'=>'raw',
                    'value' => function ($model, $key, $index, $column) use ($collection)
                    {return Html::a($model->title, ['band-of-decoration/view','id'=> $model->id, 'collection' => $collection]);}
                ],
                [
                    'format'=>'raw',
                    'label' => Yii::t('app', 'Actions'),
                    'value' => function ($model, $key, $index, $column) use ($collection)
                    {
                        return Html::a('<i class="fa fa-trash"></i>', ['band-of-decoration/delete','id'=>$model->id, 'collection' => $collection],[
                            'data' => [
                                'confirm' => Yii::t('app', 'Are you sure you want to delete this band of decoration?'),
                                'method' => 'post',
                            ]
                        ]);
                    }
                ],
                // [
                //     'class' => '\yii\grid\ActionColumn',
                //     'header' => Yii::t('app', 'Actions'),
                //     'visibleButtons' => ['delete' => true, 'update' => false, 'view' => false],
                // ]
            ],
            'options' => [
                'data' => [
                    'sortable-widget' => 1,
                    'sortable-url' => \yii\helpers\Url::toRoute(['sorting']),
                ]
            ],
            'clientOptions' => [
                "responsive"=>true,
                "paging" => false,
                "language" => [
                    "url" => Yii::t('app',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
     ?>

</div>