<?php

namespace bitcream\ndt\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%band_of_decoration}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%collection}}`
 */
class M220209105420AddCollectionIdColumnToBandOfDecorationTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%band_of_decoration}}', 'collection_id', $this->integer()->null());

        // creates index for column `collection_id`
        $this->createIndex(
            '{{%idx-band_of_decoration-collection_id}}',
            '{{%band_of_decoration}}',
            'collection_id'
        );

        // add foreign key for table `{{%collection}}`
        $this->addForeignKey(
            '{{%fk-band_of_decoration-collection_id}}',
            '{{%band_of_decoration}}',
            'collection_id',
            '{{%collection}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%collection}}`
        $this->dropForeignKey(
            '{{%fk-band_of_decoration-collection_id}}',
            '{{%band_of_decoration}}'
        );

        // drops index for column `collection_id`
        $this->dropIndex(
            '{{%idx-band_of_decoration-collection_id}}',
            '{{%band_of_decoration}}'
        );

        $this->dropColumn('{{%band_of_decoration}}', 'collection_id');
    }
}
