<?php

namespace bitcream\ndt\custom\common\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use bitcream\ndt\custom\common\models\CustomerUser;

/**
 * CustomerSearch represents the model behind the search form of `bitcream\ndt\custom\common\models\CustomerUser`.
 */
class CustomerUserSearch extends CustomerUser
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'status', 'created_at', 'updated_at'], 'integer'],
            [['username', 'name', 'surname', 'phone', 'access_token', 'auth_key', 'password_hash', 'password_reset_token', 'password_reset_expires', 'date_subscription', 'email', 'created_user_id', 'updated_user_id', 'verification_token', 'activation_key'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = CustomerUser::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'status' => $this->status,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ]);

        $query->innerJoin('auth_assignment', 'auth_assignment.user_id = user.id');
        $query->andWhere(
            [
                'item_name' => 'customer',
            ]
        );  

        // grid filtering conditions
        $query->andFilterWhere(
            ['>=', 'status', 20]
        );

        $query->andFilterWhere(['like', 'username', $this->username])
            ->andFilterWhere(['like', 'name', $this->name])
            ->andFilterWhere(['like', 'surname', $this->surname])
            ->andFilterWhere(['like', 'phone', $this->phone])
            ->andFilterWhere(['like', 'access_token', $this->access_token])
            ->andFilterWhere(['like', 'auth_key', $this->auth_key])
            ->andFilterWhere(['like', 'password_hash', $this->password_hash])
            ->andFilterWhere(['like', 'password_reset_token', $this->password_reset_token])
            ->andFilterWhere(['like', 'password_reset_expires', $this->password_reset_expires])
            ->andFilterWhere(['like', 'date_subscription', $this->date_subscription])
            ->andFilterWhere(['like', 'email', $this->email])
            ->andFilterWhere(['like', 'created_user_id', $this->created_user_id])
            ->andFilterWhere(['like', 'updated_user_id', $this->updated_user_id])
            ->andFilterWhere(['like', 'verification_token', $this->verification_token])
            ->andFilterWhere(['like', 'activation_key', $this->activation_key]);

        return $dataProvider;
    }
}
