<?php

namespace bitcream\ndt\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles dropping columns from table `{{%decoration_color}}`.
 */
class M220210122857DropBandOfDecorationIdColumnFromDecorationColorTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        // drops foreign key for table `{{%band_of_decoration}}`
        $this->dropForeignKey(
            '{{%fk-decoration_color-band_of_decoration_id}}',
            '{{%decoration_color}}'
        );

        // drops index for column `band_of_decoration_id`
        $this->dropIndex(
            '{{%idx-decoration_color-band_of_decoration_id}}',
            '{{%decoration_color}}'
        );

        $this->dropColumn('{{%decoration_color}}', 'band_of_decoration_id');
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->addColumn('{{%decoration_color}}', 'band_of_decoration_id', $this->integer());
    }
}
