<?php

namespace bitcream\ndt\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%band_of_decoration_color}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%product}}`
 */
class M220210145409DropDecorationColorIdColumnToFavouritesTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        // drops foreign key for table `{{%decoration_color}}`
        $this->dropForeignKey(
            '{{%fk-favourites-decoration_color_id}}',
            '{{%favourites}}'
        );

        // drops index for column `decoration_color_id`
        $this->dropIndex(
            '{{%idx-favourites-decoration_color_id}}',
            '{{%favourites}}'
        );

        $this->dropColumn('{{%favourites}}', 'decoration_color_id');
    }

}
