<?php

namespace bitcream\ndt\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%collection}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%user}}`
 */
class M220221130304AddCustomerUserIdColumnToCollectionTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%collection}}', 'customer_user_id', $this->integer()->null());

        // creates index for column `customer_user_id`
        $this->createIndex(
            '{{%idx-collection-customer_user_id}}',
            '{{%collection}}',
            'customer_user_id'
        );

        // add foreign key for table `{{%user}}`
        $this->addForeignKey(
            '{{%fk-collection-customer_user_id}}',
            '{{%collection}}',
            'customer_user_id',
            '{{%user}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%user}}`
        $this->dropForeignKey(
            '{{%fk-collection-customer_user_id}}',
            '{{%collection}}'
        );

        // drops index for column `customer_user_id`
        $this->dropIndex(
            '{{%idx-collection-customer_user_id}}',
            '{{%collection}}'
        );

        $this->dropColumn('{{%collection}}', 'customer_user_id');
    }
}
