<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model bitcream\ndt\custom\common\models\BandOfDecoration */

$this->title = $model->title;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Collection'), 'url' => ['collection/index']];
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', $model->collection->title), 'url' => ['collection/view', 'id' => $model->collection->id]];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="band-of-decoration-view">
    <?= $this->render('_breadcrumb')?>  
    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a(Yii::t('app', 'Update'), ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a(Yii::t('app', 'Delete'), ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'id',
            'title',
            'slug',
            'introduction_text:ntext',
            'layout',
            'layout_image_1:ntext',
            'layout_image_2:ntext',
            'layout_image_3:ntext',
            'intended_use',
        ],
    ]) ?>

    <hr>

    <h1><?= Html::encode(Yii::t('app', 'Band Of Decoration Color')) ?></h1>

    <p>
        <?= Html::a(Yii::t('app', 'Create Band Of Decoration color'), ['band-of-decoration-color/create', 'bandOfDecoration' => $model->id], ['class' => 'btn btn-success']) ?>
    </p>

    <?=  $this->render('../band-of-decoration-color/_datatable',[
            'searchModel' => $bandOfDecorationColorSearchModel,
            'dataProvider' => $dataProviderBandOfDecorationColor,
            'bandOfDecoration' => $model->id,
    ]) ?>

</div>
