<?php

namespace bitcream\ndt\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "band_of_decoration".
 *
 * @property int $id
 * @property string|null $title
 * @property string|null $slug
 * @property string|null $introduction_text
 * @property string|null $layout
 * @property string|null $layout_image_1
 * @property string|null $layout_image_2
 * @property string|null $layout_image_3
 * @property string|null $intended_use
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 * @property int|null $decoration_id
 * @property int|null $collection_id
 * @property int|null $order_priority
 *
 * @property BandOfDecorationColor[] $bandOfDecorationColors
 * @property Collection $collection
 * @property Product $decoration
 * @property Favourites[] $favourites
 */
class BandOfDecoration extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'band_of_decoration';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['introduction_text', 'layout_image_1', 'layout_image_2', 'layout_image_3'], 'string'],
            [['status', 'created_user_id', 'updated_user_id', 'decoration_id', 'collection_id', 'order_priority'], 'integer'],
            [['title', 'slug', 'layout', 'intended_use', 'created_at', 'updated_at'], 'string', 'max' => 255],
            [['collection_id'], 'exist', 'skipOnError' => true, 'targetClass' => Collection::className(), 'targetAttribute' => ['collection_id' => 'id']],
            //[['decoration_id'], 'exist', 'skipOnError' => true, 'targetClass' => Decoration::className(), 'targetAttribute' => ['decoration_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'title' => Yii::t('app', 'Title'),
            'slug' => Yii::t('app', 'Slug'),
            'introduction_text' => Yii::t('app', 'Introduction Text'),
            'layout' => Yii::t('app', 'Layout'),
            'layout_image_1' => Yii::t('app', 'Layout Image  1'),
            'layout_image_2' => Yii::t('app', 'Layout Image  2'),
            'layout_image_3' => Yii::t('app', 'Layout Image  3'),
            'intended_use' => Yii::t('app', 'Intended Use'),
            'status' => Yii::t('app', 'Status'),
            'created_at' => Yii::t('app', 'Created At'),
            'created_user_id' => Yii::t('app', 'Created User ID'),
            'updated_at' => Yii::t('app', 'Updated At'),
            'updated_user_id' => Yii::t('app', 'Updated User ID'),
            'decoration_id' => Yii::t('app', 'Decoration ID'),
            'collection_id' => Yii::t('app', 'Collection ID'),
            'order_priority' => Yii::t('app', 'Order Priority'),
        ];
    }

    /**
     * Gets query for [[BandOfDecorationColors]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getBandOfDecorationColors()
    {
        return $this->hasMany(BandOfDecorationColor::className(), ['band_of_decoration_id' => 'id']);
    }

    /**
     * Gets query for [[Collection]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCollection()
    {
        return $this->hasOne(Collection::className(), ['id' => 'collection_id']);
    }

    /**
     * Gets query for [[Favourites]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getFavourites()
    {
        return $this->hasMany(Favourites::className(), ['band_of_decoration_id' => 'id']);
    }
}
