<?php

namespace bitcream\ndt\custom\common\models\base;

use Yii;
use emberware\evidia\users\common\models\User;
/**
 * This is the model class for table "collection".
 *
 * @property int $id
 * @property string|null $title
 * @property string|null $slug
 * @property string|null $description
 * @property string|null $cover
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 *
 * @property BandOfDecoration[] $bandOfDecorations
 * @property CollectionCustomerUser[] $collectionCustomerUsers
 */
class Collection extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'collection';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['description', 'cover'], 'string'],
            [['status', 'created_user_id', 'updated_user_id'], 'integer'],
            [['title', 'slug', 'created_at', 'updated_at'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'title' => Yii::t('app', 'Title'),
            'slug' => Yii::t('app', 'Slug'),
            'description' => Yii::t('app', 'Description'),
            'cover' => Yii::t('app', 'Cover'),
            'status' => Yii::t('app', 'Status'),
            'created_at' => Yii::t('app', 'Created At'),
            'created_user_id' => Yii::t('app', 'Created User ID'),
            'updated_at' => Yii::t('app', 'Updated At'),
            'updated_user_id' => Yii::t('app', 'Updated User ID'),
        ];
    }

    /**
     * Gets query for [[BandOfDecorations]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getBandOfDecorations()
    {
        return $this->hasMany(BandOfDecoration::className(), ['collection_id' => 'id']);
    }

    /**
     * Gets query for [[CollectionCustomerUsers]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCollectionCustomerUsers()
    {
        return $this->hasMany(CollectionCustomerUser::className(), ['collection_id' => 'id'])->inverseOf('collection');
    }

    public function getCustomerUsers()
    {
        return $this->hasMany(CustomerUser::className(), ['id' => 'customer_user_id'])
            ->via('collectionCustomerUsers');
    }
}
