<?php

use yii\helpers\Html;
use kartik\export\ExportMenu;
?>
<?php 
    $gridColumns = [
        ['attribute'=>Yii::t('app', 'Customer user'),
            'format'=>'raw',
            'value' => function($data)
            {return $data->customerUser->name." ".$data->customerUser->surname;}
        ],
        ['attribute'=>Yii::t('app', 'Agent'),
            'format'=>'raw',
            'value' => function($data)
            {return $data->customerUser->agent;}
        ],
        ['attribute'=>Yii::t('app', 'Collection'),
            'format'=>'raw',
            'value' => function($data)
            {return $data->bandOfDecoration->collection->title;}
        ],
        ['attribute'=>Yii::t('app', 'Band of decoration'),
            'format'=>'raw',
            'value' => function($data)
            {return $data->bandOfDecoration->title;}
        ],
        ['attribute'=>Yii::t('app', 'Decoration color'),
            'format'=>'raw',
            'value' => function($data)
            {return $data->decorationColor->title;}
        ],
        [
            'class' => '\yii\grid\ActionColumn',
            'header' => Yii::t('app', 'Actions'),
            'visibleButtons' => ['delete' => true, 'update' => false, 'view' => false],
        ]
    ];
    ?>
    <?php
    // Renders a export dropdown menu
    echo ExportMenu::widget([
        'dataProvider' => $dataProvider,
        'columns' => $gridColumns,
        'clearBuffers' => true, //optional
    ]);
?>
<br><br>