<?php

use yii\helpers\Html;
use Emberware\Evidia\Toolkit\Model\Datatable;

?>
<div class="product-translation-datatable">
    <?=        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'product-translation-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                ['attribute'=>Yii::t('app', 'id'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->id, [Yii::$app->controller->id.'/update','id'=>$data->id]);}
                ],
                'slug',
                [
                    'class' => '\yii\grid\ActionColumn',
                    'header' => Yii::t('app', 'Actions'),
                    'visibleButtons' => ['delete' => true, 'update' => true, 'view' => true],
                ]
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('app',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
     ?>

</div>