<?php

namespace bitcream\ndt\custom\common\models;

use Yii;
use emberware\evidia\useroptions\common\models\UserOption;
use emberware\evidia\users\common\models\User;
use bitcream\ndt\custom\common\models\Customer;
use yii\helpers\ArrayHelper;
use bitcream\ndt\custom\common\behaviors\LanguageBehaviors;

/**
 * This is the model class for table "{{%user}}".
 * @property String $customerCod
 * @property String $agent
 */
class CustomerUser extends base\CustomerUser
{    
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'language' => [
                'class' => LanguageBehaviors::className(),
                'langs' => [
                    'it',
                    'en',
                ],
            ],
       ]);
    }


    public function fields(){
        return [
            'id',
            'username',
            'name',
            'surname',
            'phone',
            'customer' => 'customer',
            'agent' => 'agent',
            'email',
        ];
    }

    public function getCustomer(){
        $customer = Customer::findOne($this->customerId);
        return [
            'id' => $this->customerId,
            'name' => $customer->name,
        ];
    }

    public static function getCurrentUser(){
        return CustomerUser::findOne(Yii::$app->user->id);
    }

    public function getCustomerId(){
        return UserOption::getUserOption("customer_id", $this);
    }

    public function setCustomerId(String $customerId, $user){
        $this->unsetCustomerId($user); 
        UserOption::setUserOptionNewUser("customer_id", $customerId, $user);
        return true;
    }

    public function unsetCustomerId($user)
    {
        $customerId = UserOption::find()->where(['user_id' => $user->id, 'field' => 'customer_id'])->one();
        if($customerId){
            $customerId->delete();
        }        
        return true;
    }
    
    public function getAgent(){
        return UserOption::getUserOption("agent", $this);
    }

    public function setAgent(String $agent, $user){
        $this->unsetAgent($user); 
        UserOption::setUserOptionNewUser("agent", $agent, $user);
        return true;
    }

    public function unsetAgent($user)
    {
        $agent = UserOption::find()->where(['user_id' => $user->id, 'field' => 'agent'])->one();
        if($agent){
            $agent->delete();
        }        
        return true;
    }

    public function getLanguage(){
        return UserOption::getUserOption("language", $this);
    }

    public function setLanguage(String $language, $user){
        $this->unsetLanguage($user); 
        UserOption::setUserOptionNewUser("language", $language, $user);
        return true;
    }

    public function unsetLanguage($user)
    {
        $language = UserOption::find()->where(['user_id' => $user->id, 'field' => 'language'])->one();
        if($language){
            $language->delete();
        }        
        return true;
    }

    public static function setUserLanguage($language){
        $user = CustomerUser::getCurrentUser();
        if(isset($language)){
            return $user->setLanguage($language, $user);
        }
        return false;
    }

    public function createUser($userData){
        $model = new CustomerUser();
        $model->username = $userData['username'];
        $model->name = $userData['name'];
        $model->surname = $userData['surname'];
        $model->email = $userData['email'];
        if(!empty($userData['password_hash'])) $model->password_hash = Yii::$app->security->generatePasswordHash($userData['password_hash']);
        $model->auth_key = $model->generateAuthKey();
        $model->created_user_id = (string)Yii::$app->user->id;
        $model->updated_user_id = (string)Yii::$app->user->id;
        $model->created_at = (string)time();
        $model->updated_at = (string)time();
        $model->status = 30;
        $model->date_subscription = (string)time();
        $model->save();

        $model->setCustomerId($userData['customerId'], $model);
        $model->setAgent($userData['agent'], $model);

        $auth = \Yii::$app->authManager;
        $customerRole = $auth->getRole('customer');
        $auth->assign($customerRole, $model->id);

        return $model;
    }

    public static function getAllCustomerUsers(){

        return CustomerUser::find()
            ->join('LEFT JOIN','auth_assignment','auth_assignment.user_id = id')
            ->where(['auth_assignment.item_name' => 'customer'])
            ->all();

    }

     /**
     * Sends an email with a link, for resetting the password.
     *
     * @return bool whether the email was send
     */
    public function sendEmail($postData, $user)
    {
        $htmlBody = Yii::t('app', 'Name:')." ".$user->name." ".$user->surname."<br>".
                    Yii::t('app', 'Email:')." ".$user->email."<br>".
                    Yii::t('app', 'Phone:')." ".$user->phone."<br><br>".
                    Yii::t('app', 'Request:')." ".$postData['message'];


        return Yii::$app->mailer->compose()
            ->setTo(Yii::$app->params['supportEmail'])
            ->setFrom([$user->email => $user->name." ".$user->surname])
            ->setReplyTo(Yii::$app->params['supportEmail'])
            ->setSubject($postData['subject'])
            ->setHtmlBody($htmlBody)
            ->send();
    }

     /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return ArrayHelper::merge(parent::attributeLabels(), [
            'surname' => Yii::t('app', 'Cognome'),
            'language' => Yii::t('app', 'Lingua'),
            'agent' => Yii::t('app', 'Agente'),
        ]);
    }
}