<?php

namespace bitcream\ndt\custom\common\models;

use Yii;
use yii\helpers\ArrayHelper;
use Emberware\Evidia\Toolkit\Model\SoftDeleteBehavior;
use bitcream\ndt\custom\common\behaviors\StatusBehaviors;
use bitcream\ndt\custom\common\behaviors\CreateUpdateBehaviors;
use bitcream\ndt\custom\common\behaviors\LanguageBehaviors;

/**
 * This is the model common class for table "product_translation".
 */
class ProductTranslation extends base\ProductTranslation
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'language' => [
                'class' => LanguageBehaviors::className(),
                'langs' => [
                    'en',
                    'cn',
                ],
            ],
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
       ]);
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return ArrayHelper::merge(parent::rules(), [

        ]);
    }

     /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return ArrayHelper::merge(parent::attributeLabels(), [

        ]);
    }

    /**
     * Gets query for [[Product]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getDecoration()
    {
        return $this->hasOne(Decoration::className(), ['id' => 'product_id']);
    }
    
    public static function getTranslation($language, $products){        
        foreach($products as $product){
            if($product->getLanguage($language)){
                return $product;
            }      
        }  
        return;
    }
}
